'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database

Private Sub AktBereich_AfterUpdate()
    Me.AktBereich.SetFocus
    'Emente aktivieren/deaktivieren
    If Me.AktBereich.Value = 0 Then
        Me.AktBereich_Hoehe.Enabled = False
        Me.AktBereich_Name1.Enabled = False
        Me.AktBereich_Name2.Enabled = False
        '...
        
        Formularbereich_HF_BK.Deaktiviert = True
        Blatt1_Rot_Hoehe = 0
    Else
        Me.AktBereich_Hoehe.Enabled = True
        Me.AktBereich_Name1.Enabled = True
        Me.AktBereich_Name2.Enabled = True
        '...
        
        Formularbereich_HF_BK.Deaktiviert = False
        Blatt1_Rot_Hoehe = HF_BK_Hoehe / 5 * Twips_Faktor
    End If
    'Unter-Elemente aktivieren/deaktivieren
    AktBereich_Name1_AfterUpdate
    AktBereich_Name2_AfterUpdate
    '...
    
    'Elemente neu positionieren
    Me.Parent.Auswahl_Format_AfterUpdate
    
    'Rote Bereichsanzeige anpassen
    Me.Parent.Rote_Bereiche_Anzeigen
    
    'Steuerelement fr Formularauswahl aktualisieren
    Me.Parent.Fuellen_Auswahl_Formularbereich

End Sub

Private Sub AktBereich_Hoehe_KeyUp(KeyCode As Integer, Shift As Integer)
On Error GoTo AktBereich_Hoehe_KeyUp_ERROR
    If CDbl(Me.AktBereich_Hoehe.Text) < 0 Or CDbl(Me.AktBereich_Hoehe.Text) > 15 Then
        MsgBox "Bitte geben Sie einen Zahlenwert zwischen 0 und 15 ein.", vbInformation + vbOKOnly, "Fehler"
        If CDbl(Me.AktBereich_Hoehe.Text) > 15 Then
            Me.AktBereich_Hoehe.Value = 15
        Else
            Me.AktBereich_Hoehe.Value = 0
        End If
        Exit Sub
    End If
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Hoehe = Round(CDbl(Me.AktBereich_Hoehe.Text) / 5 * Twips_Faktor)
    Me.Parent.Rote_Bereiche_Anzeigen
AktBereich_Hoehe_KeyUp_ERROR:
    'Fehlerhafte Zahl ignorieren
End Sub

Private Sub AktBereich_Hoehe_LostFocus()
On Error GoTo AktBereich_Hoehe_LostFocus_ERROR
    'Aktuellen Daten in die Anzeige bernehmen
    HF_BK_Hoehe = CDbl(Me.AktBereich_Hoehe.Text)
On Error Resume Next
    Blatt1_Rot_Hoehe = HF_BK_Hoehe / 5 * Twips_Faktor
    Me.Parent.Rote_Bereiche_Anzeigen
    Exit Sub
AktBereich_Hoehe_LostFocus_ERROR:
    MsgBox "Bitte geben Sie eine gltige Zahl ein.", vbExclamation + vbOKOnly, "Fehler"
    Me.AktBereich_Hoehe.SetFocus
End Sub

Private Sub AktBereich_Name1_AfterUpdate()
    If Me.AktBereich_Name1.Value = 0 Or Me.AktBereich.Value = 0 Then
        'Elemente abwhlen
        Me.AktBereich_Name1_Notiz.Enabled = False
        Me.AktBereich_Name1_Oben.Enabled = False
        Me.AktBereich_Name1_Hoehe.Enabled = False
        Me.AktBereich_Name1_Links.Enabled = False
        Me.AktBereich_Name1_Breite.Enabled = False
        Me.AktBereich_Name1_Schrift.BorderColor = 12632256
        Me.AktBereich_Name1_Schrift.ForeColor = 12632256
        Me.AktBereich_Name1_Ausrichtung_Links.BorderColor = 12632256
        Me.AktBereich_Name1_Ausrichtung_Links.ForeColor = 12632256
        Me.AktBereich_Name1_Ausrichtung_Mittig.BorderColor = 12632256
        Me.AktBereich_Name1_Ausrichtung_Mittig.ForeColor = 12632256
        Me.AktBereich_Name1_Ausrichtung_Rechts.BorderColor = 12632256
        Me.AktBereich_Name1_Ausrichtung_Rechts.ForeColor = 12632256
        Me.AktBereich_Name1_Rahmen.BorderColor = 12632256
        Me.AktBereich_Name1_Rahmen.ForeColor = 12632256
        Me.AktBereich_Name1_Vergroesserbar.Enabled = False
        Me.AktBereich_Name1_Schriftmuster.ForeColor = 12632256
    Else
        'Elemente aktivieren
        Me.AktBereich_Name1_Notiz.Enabled = True
        Me.AktBereich_Name1_Oben.Enabled = True
        Me.AktBereich_Name1_Hoehe.Enabled = True
        Me.AktBereich_Name1_Links.Enabled = True
        Me.AktBereich_Name1_Breite.Enabled = True
        Me.AktBereich_Name1_Schrift.BorderColor = 0
        Me.AktBereich_Name1_Schrift.ForeColor = 0
        Me.AktBereich_Name1_Ausrichtung_Links.BorderColor = 0
        Me.AktBereich_Name1_Ausrichtung_Links.ForeColor = 0
        Me.AktBereich_Name1_Ausrichtung_Mittig.BorderColor = 0
        Me.AktBereich_Name1_Ausrichtung_Mittig.ForeColor = 0
        Me.AktBereich_Name1_Ausrichtung_Rechts.BorderColor = 0
        Me.AktBereich_Name1_Ausrichtung_Rechts.ForeColor = 0
        Me.AktBereich_Name1_Rahmen.BorderColor = 0
        Me.AktBereich_Name1_Rahmen.ForeColor = 0
        Me.AktBereich_Name1_Vergroesserbar.Enabled = True
        Me.AktBereich_Name1_Schriftmuster.ForeColor = 0
    End If
End Sub

Private Sub AktBereich_Name2_AfterUpdate()
    If Me.AktBereich_Name2.Value = 0 Or Me.AktBereich.Value = 0 Then
        'Elemente abwhlen
        Me.AktBereich_Name2_Notiz.Enabled = False
        Me.AktBereich_Name2_Oben.Enabled = False
        Me.AktBereich_Name2_Hoehe.Enabled = False
        Me.AktBereich_Name2_Links.Enabled = False
        Me.AktBereich_Name2_Breite.Enabled = False
        Me.AktBereich_Name2_Schrift.BorderColor = 12632256
        Me.AktBereich_Name2_Schrift.ForeColor = 12632256
        Me.AktBereich_Name2_Ausrichtung_Links.BorderColor = 12632256
        Me.AktBereich_Name2_Ausrichtung_Links.ForeColor = 12632256
        Me.AktBereich_Name2_Ausrichtung_Mittig.BorderColor = 12632256
        Me.AktBereich_Name2_Ausrichtung_Mittig.ForeColor = 12632256
        Me.AktBereich_Name2_Ausrichtung_Rechts.BorderColor = 12632256
        Me.AktBereich_Name2_Ausrichtung_Rechts.ForeColor = 12632256
        Me.AktBereich_Name2_Rahmen.BorderColor = 12632256
        Me.AktBereich_Name2_Rahmen.ForeColor = 12632256
        Me.AktBereich_Name2_Vergroesserbar.Enabled = False
        Me.AktBereich_Name2_Schriftmuster.ForeColor = 12632256
    Else
        'Elemente aktivieren
        Me.AktBereich_Name2_Notiz.Enabled = True
        Me.AktBereich_Name2_Oben.Enabled = True
        Me.AktBereich_Name2_Hoehe.Enabled = True
        Me.AktBereich_Name2_Links.Enabled = True
        Me.AktBereich_Name2_Breite.Enabled = True
        Me.AktBereich_Name2_Schrift.BorderColor = 0
        Me.AktBereich_Name2_Schrift.ForeColor = 0
        Me.AktBereich_Name2_Ausrichtung_Links.BorderColor = 0
        Me.AktBereich_Name2_Ausrichtung_Links.ForeColor = 0
        Me.AktBereich_Name2_Ausrichtung_Mittig.BorderColor = 0
        Me.AktBereich_Name2_Ausrichtung_Mittig.ForeColor = 0
        Me.AktBereich_Name2_Ausrichtung_Rechts.BorderColor = 0
        Me.AktBereich_Name2_Ausrichtung_Rechts.ForeColor = 0
        Me.AktBereich_Name2_Rahmen.BorderColor = 0
        Me.AktBereich_Name2_Rahmen.ForeColor = 0
        Me.AktBereich_Name2_Vergroesserbar.Enabled = True
        Me.AktBereich_Name2_Schriftmuster.ForeColor = 0
    End If
End Sub

Private Sub Form_Open(Cancel As Integer)
    'Werte bernehmen
    '...
    
    
    'Aktuellen Bereich kenntlich machen
    Blatt1_Rot_Oben = Me.Parent.Blatt1.Top + (HF_Blatt_Oben / 5 * Twips_Faktor)
    Blatt1_Rot_Links = Me.Parent.Blatt1.Left + (HF_Blatt_Links / 5 * Twips_Faktor)
    Blatt1_Rot_Hoehe = HF_BK_Hoehe / 5 * Twips_Faktor
    Blatt1_Rot_Breite = Me.Parent.Blatt1.Width - ((HF_Blatt_Links + HF_Blatt_Rechts) / 5 * Twips_Faktor)
    Blatt1_Rot_Sichtbar = True
    Blatt2_Rot_Sichtbar = False
    Me.Parent.Rote_Bereiche_Anzeigen
End Sub
